/*
 * tclDbusObject.cpp
 *
 *  Created on: Sep 12, 2012
 *      Author: rjk2hi
 */

#include <dbus/dbus.h>
#include <map>
#include <iostream>
#include "../include/CAmSocketHandler.h"
#include "../include/g3g_dbusconnection.h"
#include "../include/g3g_dbusmessagehandler.h"
#include "../include/g3g_dbusobject.h"

/*********************************************************************************
 *  Object Proxy
 *********************************************************************************/
/*
 * Constructor
 */
g3g_dbusobjectproxy::g3g_dbusobjectproxy(g3g_dbusconnection *rfConnection, const char* sNodeName, const char* sObjPath, const char* sIfName)
:m_ptrConnection(rfConnection == NULL ? NULL : rfConnection->pGetDbusConnectionPtr()),
m_matchrule(),
m_InterfaceName(sIfName),
m_ObjectPath(sObjPath),
m_NodeName(sNodeName),
m_disablepathcheck(true),
m_oMsgHandler(m_ptrConnection,m_NodeName,m_InterfaceName,m_ObjectPath)
{
	//create the match rule
	if((sObjPath == NULL)||(sIfName == NULL) ||(m_ptrConnection == NULL))
	{
		std::cout <<"Object Path or Interface Name is NULL or Connection pointer is"<<std::endl;
	}
}

bool g3g_dbusobjectproxy::bSetup()
{
	bool retval = true;

	m_disablepathcheck = false;//enable path checking
	//Store match rule internally
	m_matchrule = "type='signal',interface='" + m_InterfaceName + "',path='" + m_ObjectPath + "'";

	std::string empty;
	retval = retval && bAddMatchRule(empty,empty,m_InterfaceName,empty,m_ObjectPath);
	retval = retval && bSetupFilter();

	return retval;
}
/*
 * Helper function to add match rule
 */
bool g3g_dbusobjectproxy::bAddMatchRule(std::string type, std::string busname,std::string interface, std::string member,std::string path)
{
	std::string matchrule;
	if(type.empty())
	{
		matchrule += "type='signal'";
	}
	else
	{
		matchrule += "type='"+ type + "'";
	}
	if(!busname.empty())
	{
		matchrule += ",sender='"+busname+"'";
	}
	if(!interface.empty())
	{
		matchrule += ",interface='"+ interface + "'";
	}
	if(!member.empty())
	{
		matchrule += ",member='"+ member + "'";
	}
	if(!path.empty())
	{
		matchrule += ",path='" + path + "'";
	}
	std::cout <<"Match Rule is : "<< matchrule<<std::endl;

	DBusError err;
	dbus_error_init(&err);

	dbus_bus_add_match(m_ptrConnection,m_matchrule.c_str(),&err);
	if(dbus_error_is_set(&err))
	{
		std::cout<<"Failed to add D-Bus Match Rule "<< std::endl;
		dbus_error_free(&err);
		return false;
	}

	return true;
}
/*
 * Helper function to setup filter with no path check
 */
bool g3g_dbusobjectproxy::bSetupFilter()
{
	//Add filter function
	if(dbus_connection_add_filter(m_ptrConnection,g3g_dbusobjectproxy::dbusMessageFilter,this,NULL))
	{
#ifdef DEBUG_ENABLE
		std::cout<<"Added filter successfully"<<std::endl;
#endif
	}
	else
	{
		std::cout<<"Adding filter failed"<<std::endl;
		return false;
	}
	return true;
}
/*
 * Helper function to remove match rule
 */
bool g3g_dbusobjectproxy::bRemoveMatchRule(std::string type, std::string busname,std::string interface, std::string member,std::string path)
{
	std::string matchrule;
	if(type.empty())
	{
		matchrule += "type='signal'";
	}
	else
	{
		matchrule += "type='"+ type + "'";
	}
	if(!busname.empty())
	{
		matchrule += ",sender='"+busname+"'";
	}
	if(!interface.empty())
	{
		matchrule += ",interface='"+ interface + "'";
	}
	if(!member.empty())
	{
		matchrule += ",member='"+ member + "'";
	}
	if(!path.empty())
	{
		matchrule + ",path='" + path + "'";
	}


	DBusError err;
	dbus_error_init(&err);
	dbus_bus_remove_match(m_ptrConnection,matchrule.c_str(),&err);
	if(dbus_error_is_set(&err))
	{
		std::cout<<"Failed to Remove Dbus Match Rule "<<std::endl;
		dbus_error_free(&err);
	}
	return true;
}
/*
 * Destructor
 */
g3g_dbusobjectproxy::~g3g_dbusobjectproxy()
{
	if(!m_matchrule.empty())
	{
		DBusError err;
		dbus_error_init(&err);
		dbus_bus_remove_match(m_ptrConnection,m_matchrule.c_str(),&err);
		if(dbus_error_is_set(&err))
		{
			std::cout<<"Failed to Remove Dbus Match Rule "<<std::endl;
			dbus_error_free(&err);
		}
	}
	m_ptrConnection = NULL;
}

DBusHandlerResult g3g_dbusobjectproxy::dbusMessageFilter(DBusConnection *conn, DBusMessage *msg, void *data)
{
	(void)conn;
	if(data)
	{
		g3g_dbusmessage* dmsg = new g3g_dbusmessage(msg);
		if(dmsg == NULL)//satistfing lint
			return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

		int msgtype = dbus_message_get_type(msg); //Extract Message type
#ifdef DEBUG_ENABLE
		std::cout <<"Recieved message type "<<msgtype<<", From : "<<path<<std::endl;
#endif
		if(msgtype == DBUS_MESSAGE_TYPE_SIGNAL)
		{
			g3g_dbusobjectproxy* ptrSelf = static_cast<g3g_dbusobjectproxy*>(data);

			if((dmsg->getSenderPath() == ptrSelf->m_ObjectPath)|| ptrSelf->m_disablepathcheck)
			{
				DBusHandlerResult retval = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

				if((dmsg->getSenderInterface() == ptrSelf->m_InterfaceName)|| ptrSelf->m_disablepathcheck)
				{
					retval =  ptrSelf->eDispatch_Signal(dmsg);
				}
				delete dmsg;
				return retval;
			}
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}
/*********************************************************************************
 *  Object Adaptor
 *********************************************************************************/
std::string g3g_dbusobjectadapter::m_NodeName;

std::map<std::string,std::map< std::string,g3g_dbusobjectadapter*> > g3g_dbusobjectadapter::m_interfacelist;
/*
 * Constructor
 */
g3g_dbusobjectadapter::g3g_dbusobjectadapter(g3g_dbusconnection *rfConnection, const char* sNodeName, const char* sObjPath, const char* sIfName)
:m_ptrConnection(rfConnection == NULL ? NULL : rfConnection->pGetDbusConnectionPtr()),
m_InterfaceName(sIfName),
m_ObjectPath(sObjPath),
m_oMsgHandler(m_ptrConnection,m_InterfaceName,m_ObjectPath),
m_interfacevtable()
{
	//Setup root introspection
	if((sObjPath == NULL)||(sIfName == NULL)||(sNodeName == NULL)|| (m_ptrConnection == NULL))
	{
		std::cout <<"Object Path or Interface Name or Node Name or Dbus Connection is NULL "<<std::endl;
	}
	if(g3g_dbusobjectadapter::m_NodeName.empty())
	{
		DBusError Err;
		dbus_error_init(&Err);
		//Setup root introspection
		g3g_dbusobjectadapter::m_NodeName.assign(sNodeName);

	    int ret = dbus_bus_request_name(m_ptrConnection, m_NodeName.c_str(), DBUS_NAME_FLAG_DO_NOT_QUEUE, &Err);
	    if(dbus_error_is_set(&Err))
	    {
	    	std::cout<<"Requesting Root Node Name failed, Did someone else register our name ???"<<std::endl;
	    	dbus_error_free(&Err);
	    }
	    if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != ret)
	    {
	        std::cout<<"We are not Primary Owner ! Another instance already running?"<<std::endl;
	    }
	}
}
/*
 * Setup function, this setus up the interface
 */
bool g3g_dbusobjectadapter::bSetup()
{
	if(m_ObjectPath.empty() || m_InterfaceName.empty())
	{
		std::cout<<"Object path or interface name is empty ... sorry"<<std::endl;
		return false;
	}
	else
	{
		std::map<std::string, std::map<std::string, g3g_dbusobjectadapter*> >::iterator it = m_interfacelist.find(m_ObjectPath);
		if(it == m_interfacelist.end())
		{
			DBusError Err;
			dbus_error_init(&Err);

			//Register object path
			m_interfacevtable.message_function = &g3g_dbusobjectadapter::dbusMessageFilter;

			std::cout<<"Registering object Path = "<<m_ObjectPath<<std::endl;
			dbus_connection_register_object_path(m_ptrConnection, m_ObjectPath.c_str(), &m_interfacevtable, this);

			//Create a temp object
			std::map<std::string, g3g_dbusobjectadapter*> temp;
			temp[m_InterfaceName] = this;
			//Add it to interfacelist
			m_interfacelist[m_ObjectPath] = temp;
		}
		else
		{
			//Add the interface to interface list
			it->second[m_InterfaceName] = this;
		}
	}
	return true;
}
/*
 * Destructor
 */
g3g_dbusobjectadapter::~g3g_dbusobjectadapter()
{
	m_ptrConnection = NULL;
}
/*
 * Introspection handler
 */
DBusHandlerResult g3g_dbusobjectadapter::eRootIntrospection(DBusConnection *conn, DBusMessage *msg, void *data) const
{
	(void)data;

	//if (dbus_message_is_method_call(msg, DBUS_INTERFACE_INTROSPECTABLE, "Introspect"))
    {
#ifdef DEBUG_ENABLE
		std::cout<<"Root Introspection .."<<std::endl;
#endif
        DBusMessage * reply;
        DBusMessageIter args;
        dbus_uint32_t serial = 0;

        g3g_dbusobjectadapter* ptrSelf = static_cast<g3g_dbusobjectadapter*>(data);


        std::map<std::string,std::map<std::string,g3g_dbusobjectadapter*> >::iterator itt= m_interfacelist.find(ptrSelf->m_ObjectPath);

        std::stringstream introspect;
        //Add the intial xml header
        introspect << std::string(DBUS_INTROSPECT_1_0_XML_DOCTYPE_DECL_NODE);

        //Add Node Name here
        introspect << "<node>"<<std::endl;

        if(itt != m_interfacelist.end())
        {
        	for(std::map<std::string,g3g_dbusobjectadapter*>::iterator it = itt->second.begin(); it != itt->second.end(); it ++)
        	{
        		//Add Interface Name here
        	    introspect <<"<interface name=\""<<it->first.c_str()<<"\">"<<std::endl;
        	    //Get Methods and Signals Information from here
        	    introspect << std::string(it->second->sGetIntrospectionData());
        	    //Close Interface XML Node
        	    introspect <<G3G_DBUS_INTERFACE_END;
        	 }
        }

        //Add DBus Introspection here
       	introspect <<G3G_DBUS_INTERFACE_START("org.freedesktop.DBus.Introspectable");
       	introspect <<G3G_DBUS_METHOD_START("Introspect");
       	introspect <<G3G_DBUS_ARG_OUT("s","xml_data");
       	introspect <<G3G_DBUS_METHOD_END;
       	introspect <<G3G_DBUS_INTERFACE_END;
       	introspect <<"</node>"<<std::endl;;


       	/*
       	 * Now Send Introspection data
       	 */
       	reply = dbus_message_new_method_return(msg);
       	std::string s = introspect.str();

       	const char* str = s.c_str();

         // add the arguments to the reply
         dbus_message_iter_init_append(reply, &args);
         if (!dbus_message_iter_append_basic(&args, DBUS_TYPE_STRING, &str))
         {
             std::cout<<"DBUS Out Of Memory!"<<std::endl;
         }

         // send the reply && flush the connection
         if (!dbus_connection_send(conn, reply, &serial))
         {
            std::cout<<"DBusWrapper::~cbRootIntrospection DBUS Out Of Memory!"<<std::endl;
         }
         dbus_connection_flush(conn);
         // free the reply
         dbus_message_unref(reply);

         return (DBUS_HANDLER_RESULT_HANDLED);
    }
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

/*
 * Method call handler
 */
DBusHandlerResult g3g_dbusobjectadapter::dbusMessageFilter(DBusConnection *conn, DBusMessage *msg, void *data)
{
	DBusHandlerResult retval= DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if(data)
	{
		g3g_dbusobjectadapter* ptrSelf = static_cast<g3g_dbusobjectadapter*>(data);
		g3g_dbusmessage *dmsg = new g3g_dbusmessage(msg);
		if(dmsg == NULL)//satisfying lint
			return retval;

		//Check if Path is in our registry
		std::map<std::string,std::map<std::string,g3g_dbusobjectadapter*> >::iterator itt= m_interfacelist.find(dmsg->getSenderPath());
		if(itt != m_interfacelist.end())
		{
			//Check if interface is in our registry
			std::map<std::string,g3g_dbusobjectadapter*>::iterator it = itt->second.find(dmsg->getSenderInterface());
			if(it != itt->second.end())
			{
				retval = it->second->eDispatch_MethodCall(dmsg);
			}
		}
		//Still message not handled
		if(retval == DBUS_HANDLER_RESULT_NOT_YET_HANDLED)
		{
			if (dbus_message_is_method_call(msg, DBUS_INTERFACE_INTROSPECTABLE, "Introspect"))
			{
				retval = ptrSelf->eRootIntrospection(conn,msg,data);
			}
		}
		delete dmsg;//Free message
	}
	return retval;
}
